raw_data = readmatrix('short cutback.dat');
wavelength = raw_data(:,1);

raw_data3 = readmatrix('water_abs.txt');
wavelength3 = raw_data3(:,1);
cross_sec = raw_data3(:,2);
number_density = 4.87E-7*6.022E+23;
length = 100;
absorbance = number_density*length*cross_sec;
transmission = 10.^(-absorbance);
attenuation = -10*log10(transmission);






signal1 = (raw_data(:,4)+raw_data(:,6))/2; 
signal2 = (raw_data(:,8)+raw_data(:,10))/2;
noise = raw_data(:,2);

fig1 = figure('Color','w');
x0=10;
y0=10;
width=1500;
height=600;
p = polyfit(wavelength,noise,1);
f = polyval(p,wavelength);

nexttile
hold on
plot(wavelength,(10*log10(signal1)),'LineWidth',3,'Color','b');
plot(wavelength,(10*log10(signal2)),'LineWidth',3,'Color','r');
plot(wavelength,(10*log10(noise)),'LineWidth',3,'Color','k');
% title('Transmission')
box on
ax = gca;
ax.LineWidth = 2;
xlabel('Wavelength / nm')
ylabel('Signal (dB)')
xlim([180 210])
% legend('2.2m','1.2m','Noise')
txt4 = '(a)';
t4 = text(207,-15,txt4,'FontSize',28);
set(gca,'XMinorTick','on','YMinorTick','on')
set(gca,'FontSize',28)
set(gcf,'position',[x0,y0,width,height])

txt1 = '\leftarrow 2.2m';
t1 = text(195,-19,txt1,'FontSize',26);

txt1 = '1.2m \rightarrow ';
t2 = text(189,-18,txt1,'FontSize',26);

txt3 = '\downarrow Background';
t3 = text(200,-26,txt3,'FontSize',26);

hold off

noise = noise - f;
signal1 = signal1 - f;
signal2 = signal2 - f;

loss1 = (10*log10(signal2./signal1))/1;

% 
% nexttile
% hold on
% plot(wavelength,loss1,'LineWidth',3,'Color','k')
% plot(wavelength3,attenuation,'LineWidth',3,'Color','r')
% box on
% xlabel('Wavelength / nm')
% ylabel('Attenuation (dB/m)')
% xlim([180 210])
% ylim([0 4])
% 
% ax = gca;
% ax.LineWidth = 2;
% x2 = [180 190 190 180];
% y2 = [0 0 4 4];
% patch(x2,y2,'black','FaceAlpha',.3,'EdgeAlpha',.5)
% txt4 = '(b)';
% t4 = text(207,3.25,txt4,'FontSize',28);
% set(gca,'XMinorTick','on','YMinorTick','on')
% set(gca,'FontSize',28)
% set(gcf,'position',[x0,y0,width,height])
% hold off
% 






